﻿class program.ItemCell extends mx.core.UIComponent
{
	private var label_txt;
	private var desc_txt;
	private var settings_mc;
	private var bracket_mc;
	
	// The label to be used for text.
	private var owner;
	
	
	// The row that contains this cell.
	private var listOwner;		// The List, data grid or tree containing this cell.
	
	
	// Cell height offset from the row height total and preferred cell width.
	private static var PREFERRED_HEIGHT_OFFSET = 8;
	private static var PREFERRED_WIDTH = 352;
	
	
	// Starting depth.
	private var startDepth:Number = 1;
	
	
	// Constructor. Should be empty.
	public function ItemCell(){}
	
	
	/* UIObject expects you to fill in createChildren by instantiating all the movie clip assets you might need upon initialization. In this case we are creating one label*/
	public function createChildren():Void
	{
		// The createLabel method is a useful method of UIObject and a handy
		// way to make labels in components.
	}
	
	
	public function size():Void
	{
		/* By extending UIComponent which imports UIObject, you get setSize automatically, however, UIComponent expects you to implement size(). Assume __width and __height are set for you now. You're going to expand the cell to fit the whole rowHeight. The rowHeight itself is a property of the list type component that we are rendering a cell in. Since we want the rowHeight to fit two lines, when creating the list type component using this cellRenderer class, make sure its rowHeight property is set large enough that two lines of text can render within it.*/
		/*__width and __height are the underlying variables of the getter/setters .width and .height.*/
		// resize icon
		if(owner.item.attributes.data.data == undefined)
		{
			owner.nodeIcon._width = 80;
			owner.nodeIcon._height = 80;
			label_txt._x = 64;
		}else{
			_x = 0;
		}
		//listOwner.rowHeight = 84;
	}
	
	
	// Provides the preferred height of the cell. Inherited method.
	public function getPreferredHeight():Number
	{
		/* The cell is given a property, "owner", that references the row. It's always preferred that the cell take up most of the row's height. In this case we will keep the cell slightly smaller.*/
		var output = 22;
		if(owner.item.attributes.data.data)
			output = 80;
		//return owner.__height - PREFERRED_HEIGHT_OFFSET;
		//owner.__height = output;
		return output;
	}
	
	
	// Called by the owner to set the value in the cell. Inherited method.
	public function setValue(suggestedValue:String, item:Object, selected:Boolean):Void
	{
		/* If item is undefined, nothing should be rendered in the cell, so set the label as invisible. Note: For scrolling List type components like a scrolling datagrid, the cells are intended to be empty as they scroll just out of sight, and then the cell is reused again and set to a new value producing an animated effect of scrolling. For this reason, you cannot rely on any one cell always having data to show or the same value.*/
		// visibility
		if(item == undefined){
			settings_mc.visible = false;
			label_txt.visible = true;
		}
		
		// data
		var isItem = (item.attributes.data.data != undefined);
		if(isItem)
		{// item
			settings_mc.visible = true;
			// pass data
			settings_mc.data = item.attributes.data.data;
			label_txt.text = item.attributes.data.varName;
			desc_txt.text = item.attributes.data.desc;
			bracket_mc._visible = true;
			// hide icon
			listOwner.setIcon( owner.node, "emptyIcon" );
		}// folder
		else
		{// folder
			if(suggestedValue)
			{//if:  there's anything to display
				settings_mc.visible = false;
				bracket_mc._visible = false;
				// pass data
				label_txt.text = suggestedValue;
			}//if:  there's anything to display
		}// folder
	}// setValue()
	
	
	// function getPreferredWidth :: only for menus and DataGrid headers
	// function getCellIndex :: not used in this cell renderer
	// function getDataLabel :: not used in this cell renderer
}
